#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"
// LIST OF PRECOMPUTED SYSTEM PARAMETERS

#define KAZ_DS_SP_G				"6007"
#define KAZ_DS_SP_R				"6151"

#define KAZ_DS_SP_Q				"1115881660253397921934830780"
#define KAZ_DS_SP_q				"246208917987764371328101733"

#define KAZ_DS_SP_G0			"23102151283542472555351033031857407110549489214984451103786304558150674606117088000"
#define KAZ_DS_SP_LG0			274

#define KAZ_DS_SP_G1			"399620650696124709852000"
#define KAZ_DS_SP_LG1			79

#define KAZ_DS_SP_qQ			"37099717558444720710567318942660"

#define KAZ_DS_SP_G1Q			"445929355170334839245311003147590823180218844560000"
#define KAZ_DS_SP_G1qQ			"14825813271348122400388854921647952098272735925086320000"

#define KAZ_DS_SP_PHIG1			"60408037934094090240000"
#define KAZ_DS_SP_PHIPHIG1		"11456568251237007360000"
#define KAZ_DS_SP_PHIQ			"142607087754413919436800000"
#define KAZ_DS_SP_PHIqQ			"4741115239483245165595852800000"

#define KAZ_DS_SP_RAN			4
#define KAZ_DS_SP_A				"324324000"

#define KAZ_DS_SP_J				128
#define KAZ_DS_SP_K				128
#define KAZ_DS_SP_RHO			"582899543657382088982064123556302646979"
#define KAZ_DS_SP_G1RHO 		"232938694926837183398728616987791009425158374864155959337108000"
#define KAZ_DS_SP_LG1RHO		208
#define KAZ_DS_SP_G1QRHO 		"259932017632218835993369782263211224007969421304161083508208507352855014861224954584240000"
#define KAZ_DS_SP_G1qQRHO		"8641959790218379640271565150904983564592959350099443543397408243960370679091146065062227280000"
#define KAZ_DS_SP_PHIG1RHO		"35211817745021271488319306579933617052512436633018795294720000"
#define KAZ_DS_SP_PHIPHIG1RHO	"3339014202762851772197706809901101110783647930348396871680000"
#define KAZ_DS_SKBYTES			49
#define KAZ_DS_V1BYTES			26
#define KAZ_DS_V2BYTES			23
#define KAZ_DS_S1BYTES			49 // S1=49 bytes
#define KAZ_DS_S2BYTES			8 // S2=8 bytes

extern void KAZ_DS_CRT(int t, mpz_t *c, mpz_t *modular, mpz_t crt);

extern void KAZ_DS_KEYGEN(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
							   const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);

#endif // FILE_H_INCLUDED
